﻿const Firm = require('../models').firm;
const AllCase = require('../models').all_case;
const RateList = require('../models').rate_list;
const EmpAcl = require('../models').emp_acl;
module.exports = async (req, res, next) => {
    if (req.isAuthenticated()) {
        var firm;
        var firm_type_id;
        var case_type_logis = 0;
        if(req.user.firm_id != "0")
        {
            var firm_name = await Firm.findOne({
                where: 
                {
                  id: req.user.firm_id
                }
              });
              firm = `${firm_name.name} Legal Central`;
              firm_type_id = firm_name.firm_type_id
              if(firm_type_id == "5")
              {
                    var case_type_logis = await RateList.findAll({
                      where: {
                          firm_type_id: firm_type_id,
                          firm_id: req.user.firm_id
                      },
                      order: [['type_of_case','ASC']]
                  })
                  res.locals.case_type_logis = case_type_logis
              }
        }
        else
        {
            firm = "Legal Central"
        }
        if(req.user.role_id == "1")
        {
            Firm.hasMany(RateList, {
                foreignKey: 'firm_id'
            });
            var case_type_logis_get_site_admin = await Firm.findAll({
                where: {
                    firm_type_id: 5
                },
                include: [{
                    model: RateList
                }]
            })
            res.locals.case_type_logis_get_site_admin = case_type_logis_get_site_admin
        }

        var all_cases_allocated_length = await AllCase.findAll({
            where: {
                status: 0
            }
        });
        var all_cases_challan = await AllCase.findAll({
            where: {
                case_type_id: 7,
                status: 0
            }
        });
        var all_cases_superdari = await AllCase.findAll({
            where: {
                case_type_id: 6,
                status: 0
            }
        });
        var all_cases_mact = await AllCase.findAll({
            where: {
                case_type_id: 2,
                status: 0
            }
        });
        var all_cases_consumer = await AllCase.findAll({
            where: {
                case_type_id: 1,
                status: 0
            }
        });
        var all_cases_warrant = await AllCase.findAll({
            where: {
                case_type_id: 5,
                status: 0
            }
        });
        var all_cases_fir_complaint = await AllCase.findAll({
            where: {
                case_type_id: 4,
                status: 0
            }
        });
        var all_cases_new_police_representation = await AllCase.findAll({
            where: {
                case_type_id: 11,
                status: 0
            }
        });
        var all_cases_new_surety_required = await AllCase.findAll({
            where: {
                case_type_id: 12,
                status: 0
            }
        });
        var invitation_pendency = await AllCase.findAll({
            where: {
                invitation: 0,
                status: 3
            }
        })
        // *********************** STARTS EMPLOYEE ACL ******************************** //
        if(req.user.role_id == "4")
        {
            var emp_acl_list = await EmpAcl.findAll({
                where: {
                    user_id: req.user.id
                }
            });
            // console.log(emp_acl_list)
            res.locals.emp_acl_list = emp_acl_list
        }
        
        // *********************** ENDS EMPLOYEE ACL ******************************** //
        const ulrArr = req.originalUrl.split("/");
        delete req.user.password;
        res.locals.user = req.user;
        res.locals.client_url = ulrArr[1];
        res.locals.firm = firm;
        res.locals.firm_type_id = firm_type_id;
        res.locals.all_cases_allocated_count = all_cases_allocated_length.length != 0 ? `(${all_cases_allocated_length.length})`: "";
        res.locals.new_challan_count = all_cases_challan.length != 0 ? `(${all_cases_challan.length})`: "";
        res.locals.new_superdari_count = all_cases_superdari.length != 0 ? `(${all_cases_superdari.length})`: "";
        res.locals.new_mact_count = all_cases_mact.length != 0 ? `(${all_cases_mact.length})`: "";
        res.locals.new_consumer_count = all_cases_consumer.length != 0 ? `(${all_cases_consumer.length})`: "";
        res.locals.new_warrant_count = all_cases_warrant.length != 0 ? `(${all_cases_warrant.length})`: "";
        res.locals.new_fir_complaint_count = all_cases_fir_complaint.length != 0 ? `(${all_cases_fir_complaint.length})`: "";
        res.locals.new_police_representation_count = all_cases_new_police_representation.length != 0 ? `(${all_cases_new_police_representation.length})`: "";
        res.locals.new_surety_required_count = all_cases_new_surety_required.length != 0 ? `(${all_cases_new_surety_required.length})`: "";
        res.locals.new_invi_pendency_count = invitation_pendency.length != 0 ? invitation_pendency.length: "";
        res.locals.year = new Date().getFullYear();
        
        return next();
    }
    res.redirect('/');
};

